/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

import java.util.List;

/**
 * User group JEO handler.
 *
 * @author [YN] Yulya Neymirok
 * @version $Revision: 1.1 $ $Date: 2005/09/27 12:08:49 $
 */

public class UserGroupObjectHandler
    extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return "groupmember";
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return UserGroupObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the workgroup by ID (primary key).
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param id workgroup key to search by
     * @return workgroup JEO handler, or <code>null</code> if none found
     * @throws com.queplix.core.modules.eql.error.EQLException
     */
    public static JEObjectHandler selectByID( JEOManagerLocal manager, LogonSession ls, long id )
        throws EQLException {

        String eql = "select /* pageSize=1 */ groupmember.* where groupmember.pkey = " + id;

        List hndList = manager.select( ls, UserGroupObjectHandler.class, eql );
        if( hndList != null ) {
            return( JEObjectHandler ) hndList.get( 0 );
        } else {
            return null;
        }
    }

    public static Integer selectNotifyMethod(EQLManagerLocal eqlManager, LogonSession ls, long userId, int userType, long groupId )
        throws EQLException {
        String eql = "select groupmember.notifymethod where groupmember.employeegroup = " + userId + 
                     " and 0 >= " + userType + " and groupmember.workgroupgroup = " + groupId;
        EQLRes eqlRes = eqlManager.select( ls, eql );
        return (eqlManager.selectCount( ls, eqlRes ) > 0)? eqlRes.getRecord(0).getResCell(0).getInteger() : null;
    }
    
}
