/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

import java.util.List;

/**
 * <p>User Log Handler</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:48 $
 */
public class UserLogObjectHandler
    extends JEObjectHandler {

    public String getEntityName() {
        return "user_log";
    }

    public Class getObjectClass() {
        return UserLogObject.class;
    }

    public static List selectBySessoinId( JEOManagerLocal local, LogonSession ls, String sessionId )
        throws EQLException {

        String eql = "SELECT user_log.* WHERE user_log.session_id = '" + sessionId +
            "' ORDER BY user_log.user_log_id DESC";
        return local.select( ls, UserLogObjectHandler.class, eql );
    }
}
