/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import com.queplix.core.modules.eql.EQLObject;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.parser.EQLIntPreparedStatement;
import com.queplix.core.modules.jeo.JEObject;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * User JEO handler.
 *
 * @author [LIV] Ladnev Ilya
 * @author [MVT] Michael Trofimov
 * @version $Revision: 1.2 $ $Date: 2006/06/04 00:15:09 $
 */
public class UserObjectHandler extends JEObjectHandler {

    public final static String ENTITY_NAME = "users";

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return ENTITY_NAME;
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return UserObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the user by ID (primary key).
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param id user's key to search by
     * @return user JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectHandlerByID( JEOManagerLocal manager, LogonSession ls, long id )
        throws EQLException {

        String eql = "select /* pageSize=1 */ users.* where users.pkey = " + id;
        List hndList = manager.select( ls, UserObjectHandler.class, eql );
        return( hndList != null ) ? ( JEObjectHandler ) hndList.get( 0 ) : null;
    }

    /**
     * Gets the user by ID (primary key).
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param id user's key to search by
     * @return user JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static UserObject selectObjectByID( JEOManagerLocal manager, LogonSession ls, long id )
            throws EQLException {

        String eql = "select /* pageSize=1 */ users.* where users.pkey = ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(id));

        List hndList = manager.select(ls, UserObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        JEObject jeo = ((JEObjectHandler) hndList.get(0)).getJEObject();
        return (UserObject) jeo;
    }   

    /**
     * Gets the user by login.
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param loginname user's login name to search by
     * @return user JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectByLogin( JEOManagerLocal manager, LogonSession ls, String loginname )
        throws EQLException {

        String eql = "select /* pageSize=1 */ users.* where users.loginname = '" + loginname + "'";
        List hndList = manager.select( ls, UserObjectHandler.class, eql );
        return( hndList != null ) ? ( JEObjectHandler ) hndList.get( 0 ) : null;
    }   

    /**
     * Gets the user by login and password digest.
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param loginName user's login name to search by
     * @param passwordDigest user's password digest to search by
     * @return user JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static UserObject selectByLoginAndPassword(
            JEOManagerLocal manager, LogonSession ls, String loginName, String passwordDigest)
        throws EQLException {

        String eql = "select /* pageSize=1 */ users.* where users.loginname = ? and (users.password = ? or users.password is null)";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(loginName));
        stat.setObject(2, EQLObject.getInstance(passwordDigest));

        List hndList = manager.select(ls, UserObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        JEObject jeo = ((JEObjectHandler) hndList.get(0)).getJEObject();
        return (UserObject) jeo;
    }

    public static List<UserObject> selectByWorkgroupID(
            JEOManagerLocal manager, LogonSession ls, Long workgroupID) throws EQLException {

        String eql = "select users.* where workgroup.pkey = ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(workgroupID));

        List hndList = manager.select(ls, UserObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        List<UserObject> users = new ArrayList<UserObject>();
        for (Iterator iter = hndList.iterator(); iter.hasNext();) {
            JEObjectHandler hnd = (JEObjectHandler) iter.next();
            users.add((UserObject) hnd.getJEObject());
        }
        return users;
    }   

    public static List<UserObject> selectByWorkgroupIDAndTier(
            JEOManagerLocal manager, LogonSession ls, Long workgroupID, Integer groupmemberTier)
                throws EQLException {

        String eql = "select users.* where workgroup.pkey = ? and groupmember.tier = ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(workgroupID));
        stat.setObject(2, EQLObject.getInstance(groupmemberTier));

        List hndList = manager.select(ls, UserObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        List<UserObject> users = new ArrayList<UserObject>();
        for (Iterator iter = hndList.iterator(); iter.hasNext();) {
            JEObjectHandler hnd = (JEObjectHandler) iter.next();
            users.add((UserObject) hnd.getJEObject());
        }
        return users;
    }

    public static List<UserObject> selectAll(JEOManagerLocal manager, LogonSession ls)
                throws EQLException {

        List hndList = manager.select(ls, UserObjectHandler.class, "select users.*");
        if(hndList == null)
            return null;

        List<UserObject> users = new ArrayList<UserObject>();
        for (Iterator iter = hndList.iterator(); iter.hasNext();) {
            JEObjectHandler hnd = (JEObjectHandler) iter.next();
            users.add((UserObject) hnd.getJEObject());
        }
        return users;
    }

}
