/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.EQLObject;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.parser.EQLIntPreparedStatement;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

public class UserPermissionsObjectHandler extends JEObjectHandler {

    public final static String ENTITY_NAME = "user_permissions";
    
    @Override
    public String getEntityName() {
        return ENTITY_NAME;
    }

    @Override
    public Class getObjectClass() {
        return UserPermissionsObject.class;
    }

    public static List<UserPermissionsObject> selectByUserID(
            JEOManagerLocal manager, LogonSession ls, Long userID) throws EQLException {
        
        String eql = "select user_permissions.* where user_permissions.user_id = ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(userID));

        List hndList = manager.select(ls, UserPermissionsObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        List<UserPermissionsObject> userPermissions = new ArrayList<UserPermissionsObject>();
        for (Iterator iter = hndList.iterator(); iter.hasNext();) {
            JEObjectHandler hnd = (JEObjectHandler) iter.next();
            userPermissions.add((UserPermissionsObject) hnd.getJEObject());
        }
        return userPermissions;
    }

}
