/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.EQLObject;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.parser.EQLIntPreparedStatement;
import com.queplix.core.modules.jeo.JEObject;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

/**
 * User Settings JEO handler.
 *
 * @author [LIV] Ladnev ILya
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:48 $
 */
public class UserRolesObjectHandler
    extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return "user_roles";
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return UserRolesObject.class;
    }
    
    public static List<UserRolesObject> selectByUser(
            JEOManagerLocal manager, LogonSession ls, UserObject user) throws EQLException {
        
        String eql = "select user_roles.* where user_roles.user_id = ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(user.getPkey()));

        List hndList = manager.select(ls, UserRolesObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        List<UserRolesObject> roles = new ArrayList<UserRolesObject>();
        for (Iterator iter = hndList.iterator(); iter.hasNext();) {
            JEObjectHandler hnd = (JEObjectHandler) iter.next();
            roles.add( (UserRolesObject)hnd.getJEObject() );
        }
        return roles;
    }

}
