/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.jeo.gen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.EQLObject;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.parser.EQLIntPreparedStatement;
import com.queplix.core.modules.jeo.JEObject;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

/**
 * Workgroup JEO handler.
 * 
 * @author [MVT] Michael Trofimov
 * @version $Revision$ 
 */
public class WorkgroupObjectHandler extends JEObjectHandler {

    private static final long serialVersionUID = -8881523032654520992L;

    public final static String ENTITY_NAME = "workgroup";
    
    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    @Override
    public String getEntityName() {
        return ENTITY_NAME;
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    @Override
    public Class getObjectClass() {
        return WorkgroupObject.class;
    }

    public static WorkgroupObject selectByID(
            JEOManagerLocal manager, LogonSession ls, Long workgroupID) throws EQLException {
        
        String eql = "select workgroup.* where workgroup.pkey = ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(workgroupID));

        List hndList = manager.select(ls, WorkgroupObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        JEObject jeo = ((JEObjectHandler) hndList.get(0)).getJEObject();
        return (WorkgroupObject) jeo;
    }
    
    public static List<WorkgroupObject> selectByUser(
            JEOManagerLocal manager, LogonSession ls, UserObject user) throws EQLException {
        
        String eql = "select workgroup.* where users.pkey = ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(user.getPkey()));

        List hndList = manager.select(ls, WorkgroupObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        List<WorkgroupObject> workgroups = new ArrayList<WorkgroupObject>();
        for (Iterator iter = hndList.iterator(); iter.hasNext();) {
            JEObjectHandler hnd = (JEObjectHandler) iter.next();
            workgroups.add( (WorkgroupObject)hnd.getJEObject() );
        }
        return workgroups;
    }

}
