/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.mail.utils;

import javax.activation.DataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * E-mail data source - helper class, to wrap a data source.
 * @author [DAG] Dmitry Gaponenko
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.2 $ $Date: 2006/01/26 15:00:53 $
 */

public class MailDataSource
    implements DataSource {

    private byte[] data; // data for mail message
    private String type; // content type/mime type

    public MailDataSource( byte[] data, String type ) {
        this.data = data;
        this.type = type;
    }

    public InputStream getInputStream()
        throws IOException {
        if( data == null ) {
            throw new IOException( "No data." );
        }
        return new ByteArrayInputStream( data );
    }

    public OutputStream getOutputStream()
        throws IOException {
        throw new IOException( "Illegal operation." );
    }

    public String getContentType() {
        return type;
    }

    public String getName() {
        return "dummy";
    }

} // end of class
