/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.security;

import com.queplix.core.integrator.security.BadNameOrPasswordException;
import com.queplix.core.modules.jeo.gen.UserObject;

/**
 * Interface represents the Login Module.
 * @author [AZ] Andrei Zudin
 * @version $Revision: 1.1 $ $Date: 2007/04/12 06:53:01 $
 */

public interface LoginModule {

    
    /**
     * Authenticates user by supplied login name and password.
     *
     * @param loginName user login
     * @param password  password
     * @return User
     * @throws BadNameOrPasswordException thrown if no such user exists in DB.
     */
    public UserObject doLogin (String loginName, String password) throws BadNameOrPasswordException; 
    
}
