/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.services.utils.log.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.services.utils.log.AbstractLogPublisher;
import com.queplix.core.modules.services.utils.log.Level;

/**
 * Generic log publisher implementation.
 * 
 * @author [ALB] Andrey Baranov
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:02 $
 */
public class BaseLogPublisher extends AbstractLogPublisher {

    // ================================================================== Fields

    // Process ID.
    private long processID;

    // ========================================================== Initialization

    /**
     * Creates a new log publisher.
     * @param ls user logon session
     */
    public BaseLogPublisher(LogonSession ls) {
        this(ls, getProcessIDfromTime());
    }

    /**
     * Creates a new log publisher.
     * 
     * @param ls user logon session
     * @param processID process ID
     */
    public BaseLogPublisher(LogonSession ls, long processID) {
        super(ls);
        if (processID <= 0) {
            throw new IllegalStateException("Incorrect process ID");
        }
        this.processID = processID;
    }

    // ========================================================== Public methods

    /**
     * Log process ID getter.
     * @return unique process ID
     */
    public final long getProcessID() {
        return processID;
    }

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see AbstractLogPublisher#ERROR(String)
     */
    public void ERROR(String message) {
        LogonSession ls = getLogonSession();
        BaseLogRecord lr = new BaseLogRecord(ls, Level.ERROR, message, processID);
        publish(lr);
    }

    /* (non-Javadoc)
     * @see AbstractLogPublisher#WARN(String)
     */
    public void WARN(String message) {
        LogonSession ls = getLogonSession();
        BaseLogRecord lr = new BaseLogRecord(ls, Level.WARNING, message, processID);
        publish(lr);
    }

    /* (non-Javadoc)
     * @see AbstractLogPublisher#INFO(String)
     */
    public void INFO(String message) {
        LogonSession ls = getLogonSession();
        BaseLogRecord lr = new BaseLogRecord(ls, Level.INFO, message, processID);
        publish(lr);
    }

    /* (non-Javadoc)
     * @see AbstractLogPublisher#DEBUG(String)
     */
    public void DEBUG(String message) {
        LogonSession ls = getLogonSession();
        BaseLogRecord lr = new BaseLogRecord(ls, Level.DEBUG, message, processID);
        publish(lr);
    }

    // ========================================================= Private methods

    // Unique process ID getter.
    private static synchronized final long getProcessIDfromTime() {
        return System.currentTimeMillis();
    }

}
