/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.services.utils.log.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.services.utils.log.AbstractLogRecord;
import com.queplix.core.modules.services.utils.log.Level;

/**
 * Generic log record value object class.
 * 
 * @author [ALB] Andrey Baranov
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:02 $
 */
public class BaseLogRecord extends AbstractLogRecord {

    // ================================================================== Fields

    // Process ID.
    private long processID;

    // ========================================================== Initialization

    /**
     * Creates a new log record.
     * 
     * @param ls user logon session
     * @param level log level
     * @param message the message to log
     * @param processID process ID
     */
    protected BaseLogRecord(LogonSession ls, Level level, String message, long processID) {
        super(ls, level, message);
        if (processID <= 0L) {
            throw new IllegalStateException("Invalid process ID");
        }
        this.processID = processID;
    }

    // ========================================================== Public methods

    /**
     * Process ID getter.
     * @return process ID
     */
    public long getProcessID() {
        return processID;
    }

    /**
     * Get log class (or channel) ID.
     * @return unique log class
     */
    public int getClassID() {
        return 0;
    }

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see AbstractLogRecord#getHndClassName
     */
    public String getHndClassName() {
        return "com.queplix.core.modules.services.utils.log.impl.BaseLogHandler";
    }

}
