/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.services.utils.log.impl;

import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.utils.DateHelper;

import java.util.Date;
import java.util.Properties;
import java.net.InetAddress;

import com.queplix.core.integrator.security.LogonSession;

/**
 * Project Mail LOG message handler
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.3 $ $Date: 2005/05/13 02:25:29 $
 */

public class DefMailMsgHnd
        extends MailMessageHandler {

    protected void init() {

        MailLogRecord record = getLogRecord();
        LogonSession sc = record.getLogonSession();
        String errorClass = ( record.getCause() == null ) ? null : record.getCause().getClass().getName();
        String errorMsg = record.getMessage();
        String errorTrace = record.getStackTrace();

        // Checking.
        if( errorMsg == null ) {
            errorMsg = "[empty]";
        }
        if( errorTrace == null ) {
            errorTrace = "[empty]";
        }

        // Create mail message an subject.
        String mailSubject = "SYSTEM ALERT (QSUPPORT)";

        String mailMessage =
            "SYSTEM ERROR OCCURED\n\n" +
            "============================================== \n\n" +
            "Project: QSUPPORT\n" +
            "Version: " + getVersion() + "\n" +
            "Local date: " + new Date( System.currentTimeMillis() ) + "\n" +
            "GMT date: " + DateHelper.formatDate( DateHelper.getNowDate() ) + "\n";

        try {
            mailMessage += "Host: " + InetAddress.getLocalHost().getHostName() +
                " (" + InetAddress.getLocalHost().getHostAddress() + ")\n";
        } catch( Exception e ) {}

        if( sc != null ) {
            mailMessage +=
                "User: " + sc.getUser().getUserID() + "\n" +
//                "User type: " + sc.getUser().getUserTypeID() + "\n" +
                "Login: " + sc.getUser().getLoginName() + "\n" +
                "Full name: " + sc.getUser().getFullName() + "\n";
        }

        mailMessage +=
            "Class: " + record.getSenderClass() + "\n" +
            "Error class: " + errorClass + "\n" +
            "Error message:\n\n" + errorMsg + "\n\n" +
            "============================================== \n\n" +
            "Stack trace:\n\n" + errorTrace + "\n\n" +
            "==============================================";

        // Ok.
        setSubject( mailSubject );
        setBody( mailMessage );
    }

    // Get product version
    private String getVersion() {
        try {
            Properties props = new Properties();
            props.load( getClass().getClassLoader().getResourceAsStream( "VERSION" ) );
            return props.getProperty( "version" );
        } catch( Throwable t ) {
            return "unknown";
        }
    }
}

