/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils;

/**
 * Convert some UTF characters to HTML entities
 * See: http://www.w3.org/TR/REC-html40/sgml/entities.html.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:16 $
 */

public class HTMLEntityEncoder {

	// Convert char to Entity
    public static String toEntity( char c ) {

        switch( c ) {

/* [ALB] don't replace these symbols!

            case '\u00A0':
                return "&nbsp;";

            case '\u00A1':
                return "&iexcl;";

            case '\u00A2':
                return "&cent;";

            case '\u00A3':
                return "&pound;";

            case '\u00A4':
                return "&curren;";

            case '\u00A5':
                return "&yen;";

            case '\u00A6':
                return "&brvbar;";

            case '\u00A7':
                return "&sect;";

            case '\u00A8':
                return "&uml;";

            case '\u00A9':
                return "&copy;";

            case '\u00AA':
                return "&ordf;";

            case '\u00AB':
                return "&laquo;";

            case '\u00AC':
                return "&not;";

            case '\u00AD':
                return "&shy;";

            case '\u00AE':
                return "&reg;";

            case '\u00AF':
                return "&macr;";

            case '\u00B0':
                return "&deg;";

            case '\u00B1':
                return "&plusmn;";

            case '\u00B2':
                return "&sup2;";

            case '\u00B3':
                return "&sup3;";

            case '\u00B4':
                return "&acute;";

            case '\u00B5':
                return "&micro;";

            case '\u00B6':
                return "&para;";

            case '\u00B7':
                return "&middot;";

            case '\u00B8':
                return "&cedil;";

            case '\u00B9':
                return "&sup1;";

            case '\u00BA':
                return "&ordm;";

            case '\u00BB':
                return "&raquo;";

            case '\u00BC':
                return "&frac14;";

            case '\u00BD':
                return "&frac12;";

            case '\u00BE':
                return "&frac34;";

            case '\u00BF':
                return "&iquest;";

            case '\u00C0':
                return "&Agrave;";

            case '\u00C1':
                return "&Aacute;";

            case '\u00C2':
                return "&Acirc;";

            case '\u00C3':
                return "&Atilde;";

            case '\u00C4':
                return "&Auml;";

            case '\u00C5':
                return "&Aring;";

            case '\u00C6':
                return "&AElig;";

            case '\u00C7':
                return "&Ccedil;";

            case '\u00C8':
                return "&Egrave;";

            case '\u00C9':
                return "&Eacute;";

            case '\u00CA':
                return "&Ecirc;";

            case '\u00CB':
                return "&Euml;";

            case '\u00CC':
                return "&Igrave;";

            case '\u00CD':
                return "&Iacute;";

            case '\u00CE':
                return "&Icirc;";

            case '\u00CF':
                return "&Iuml;";

            case '\u00D0':
                return "&ETH;";

            case '\u00D1':
                return "&Ntilde;";

            case '\u00D2':
                return "&Ograve;";

            case '\u00D3':
                return "&Oacute;";

            case '\u00D4':
                return "&Ocirc;";

            case '\u00D5':
                return "&Otilde;";

            case '\u00D6':
                return "&Ouml;";

            case '\u00D7':
                return "&times;";

            case '\u00D8':
                return "&Oslash;";

            case '\u00D9':
                return "&Ugrave;";

            case '\u00DA':
                return "&Uacute;";

            case '\u00DB':
                return "&Ucirc;";

            case '\u00DC':
                return "&Uuml;";

            case '\u00DD':
                return "&Yacute;";

            case '\u00DE':
                return "&THORN;";

            case '\u00DF':
                return "&szlig;";

            case '\u00E0':
                return "&agrave;";

            case '\u00E1':
                return "&aacute;";

            case '\u00E2':
                return "&acirc;";

            case '\u00E3':
                return "&atilde;";

            case '\u00E4':
                return "&auml;";

            case '\u00E5':
                return "&aring;";

            case '\u00E6':
                return "&aelig;";

            case '\u00E7':
                return "&ccedil;";

            case '\u00E8':
                return "&egrave;";

            case '\u00E9':
                return "&eacute;";

            case '\u00EA':
                return "&ecirc;";

            case '\u00EB':
                return "&euml;";

            case '\u00EC':
                return "&igrave;";

            case '\u00ED':
                return "&iacute;";

            case '\u00EE':
                return "&icirc;";

            case '\u00EF':
                return "&iuml;";

            case '\u00F0':
                return "&eth;";

            case '\u00F1':
                return "&ntilde;";

            case '\u00F2':
                return "&ograve;";

            case '\u00F3':
                return "&oacute;";

            case '\u00F4':
                return "&ocirc;";

            case '\u00F5':
                return "&otilde;";

            case '\u00F6':
                return "&ouml;";

            case '\u00F7':
                return "&divide;";

            case '\u00F8':
                return "&oslash;";

            case '\u00F9':
                return "&ugrave;";

            case '\u00FA':
                return "&uacute;";

            case '\u00FB':
                return "&ucirc;";

            case '\u00FC':
                return "&uuml;";

            case '\u00FD':
                return "&yacute;";

            case '\u00FE':
                return "&thorn;";

            case '\u00FF':
                return "&yuml;";

            case '\u0022':
                return "&quot;";

            case '\u0026':
                return "&amp;";

            case '\u003C':
                return "&lt;";

            case '\u003E':
                return "&gt;";
*/

            case '\u0192':
                return "&fnof;";

            case '\u0391':
                return "&Alpha;";

            case '\u0392':
                return "&Beta;";

            case '\u0393':
                return "&Gamma;";

            case '\u0394':
                return "&Delta;";

            case '\u0395':
                return "&Epsilon;";

            case '\u0396':
                return "&Zeta;";

            case '\u0397':
                return "&Eta;";

            case '\u0398':
                return "&Theta;";

            case '\u0399':
                return "&Iota;";

            case '\u039A':
                return "&Kappa;";

            case '\u039B':
                return "&Lambda;";

            case '\u039C':
                return "&Mu;";

            case '\u039D':
                return "&Nu;";

            case '\u039E':
                return "&Xi;";

            case '\u039F':
                return "&Omicron;";

            case '\u03A0':
                return "&Pi;";

            case '\u03A1':
                return "&Rho;";

            case '\u03A3':
                return "&Sigma;";

            case '\u03A4':
                return "&Tau;";

            case '\u03A5':
                return "&Upsilon;";

            case '\u03A6':
                return "&Phi;";

            case '\u03A7':
                return "&Chi;";

            case '\u03A8':
                return "&Psi;";

            case '\u03A9':
                return "&Omega;";

            case '\u03B1':
                return "&alpha;";

            case '\u03B2':
                return "&beta;";

            case '\u03B3':
                return "&gamma;";

            case '\u03B4':
                return "&delta;";

            case '\u03B5':
                return "&epsilon;";

            case '\u03B6':
                return "&zeta;";

            case '\u03B7':
                return "&eta;";

            case '\u03B8':
                return "&theta;";

            case '\u03B9':
                return "&iota;";

            case '\u03BA':
                return "&kappa;";

            case '\u03BB':
                return "&lambda;";

            case '\u03BC':
                return "&mu;";

            case '\u03BD':
                return "&nu;";

            case '\u03BE':
                return "&xi;";

            case '\u03BF':
                return "&omicron;";

            case '\u03C0':
                return "&pi;";

            case '\u03C1':
                return "&rho;";

            case '\u03C2':
                return "&sigmaf;";

            case '\u03C3':
                return "&sigma;";

            case '\u03C4':
                return "&tau;";

            case '\u03C5':
                return "&upsilon;";

            case '\u03C6':
                return "&phi;";

            case '\u03C7':
                return "&chi;";

            case '\u03C8':
                return "&psi;";

            case '\u03C9':
                return "&omega;";

            case '\u03D1':
                return "&thetasym;";

            case '\u03D2':
                return "&upsih;";

            case '\u03D6':
                return "&piv;";

            case '\u2219':
                return "&bull;";

            case '\u2026':
                return "&hellip;";

            case '\u2032':
                return "&prime;";

            case '\u2033':
                return "&Prime;";

            case '\u203E':
                return "&oline;";

            case '\u2044':
                return "&frasl;";

            case '\u2118':
                return "&weierp;";

            case '\u2111':
                return "&image;";

            case '\u211C':
                return "&real;";

            case '\u2122':
                return "&trade;";

            case '\u2135':
                return "&alefsym;";

            case '\u2190':
                return "&larr;";

            case '\u2191':
                return "&uarr;";

            case '\u2192':
                return "&rarr;";

            case '\u2193':
                return "&darr;";

            case '\u2194':
                return "&harr;";

            case '\u21B5':
                return "&crarr;";

            case '\u21D0':
                return "&lArr;";

            case '\u21D1':
                return "&uArr;";

            case '\u21D2':
                return "&rArr;";

            case '\u21D3':
                return "&dArr;";

            case '\u21D4':
                return "&hArr;";

            case '\u2200':
                return "&forall;";

            case '\u2202':
                return "&part;";

            case '\u2203':
                return "&exist;";

            case '\u2205':
                return "&empty;";

            case '\u2207':
                return "&nabla;";

            case '\u2208':
                return "&isin;";

            case '\u2209':
                return "&notin;";

            case '\u220B':
                return "&ni;";

            case '\u220F':
                return "&prod;";

            case '\u2211':
                return "&sum;";

            case '\u2212':
                return "&minus;";

            case '\u2217':
                return "&lowast;";

            case '\u221A':
                return "&radic;";

            case '\u221D':
                return "&prop;";

            case '\u221E':
                return "&infin;";

            case '\u2220':
                return "&ang;";

            case '\u2227':
                return "&and;";

            case '\u2228':
                return "&or;";

            case '\u2229':
                return "&cap;";

            case '\u222A':
                return "&cup;";

            case '\u222B':
                return "&int;";

            case '\u2234':
                return "&there4;";

            case '\u223C':
                return "&sim;";

            case '\u2245':
                return "&cong;";

            case '\u2248':
                return "&asymp;";

            case '\u2260':
                return "&ne;";

            case '\u2261':
                return "&equiv;";

            case '\u2264':
                return "&le;";

            case '\u2265':
                return "&ge;";

            case '\u2282':
                return "&sub;";

            case '\u2283':
                return "&sup;";

            case '\u2284':
                return "&nsub;";

            case '\u2286':
                return "&sube;";

            case '\u2287':
                return "&supe;";

            case '\u2295':
                return "&oplus;";

            case '\u2297':
                return "&otimes;";

            case '\u22A5':
                return "&perp;";

            case '\u22C5':
                return "&sdot;";

            case '\u2308':
                return "&lceil;";

            case '\u2309':
                return "&rceil;";

            case '\u230A':
                return "&lfloor;";

            case '\u230B':
                return "&rfloor;";

            case '\u2329':
                return "&lang;";

            case '\u232A':
                return "&rang;";

            case '\u25CA':
                return "&loz;";

            case '\u2660':
                return "&spades;";

            case '\u2663':
                return "&clubs;";

            case '\u2665':
                return "&hearts;";

            case '\u2666':
                return "&diams;";

            case '\u0152':
                return "&OElig;";

            case '\u0153':
                return "&oelig;";

            case '\u0160':
                return "&Scaron;";

            case '\u0161':
                return "&scaron;";

            case '\u0178':
                return "&Yuml;";

            case '\u02C6':
                return "&circ;";

            case '\u02DC':
                return "&tilde;";

            case '\u2002':
                return "&ensp;";

            case '\u2003':
                return "&emsp;";

            case '\u2009':
                return "&thinsp;";

            case '\u200C':
                return "&zwnj;";

            case '\u200D':
                return "&zwj;";

            case '\u200E':
                return "&lrm;";

            case '\u200F':
                return "&rlm;";

            case '\u2013':
                return "&ndash;";

            case '\u2014':
                return "&mdash;";

            case '\u2018':
                return "&lsquo;";

            case '\u2019':
                return "&rsquo;";

            case '\u201A':
                return "&sbquo;";

            case '\u201C':
                return "&ldquo;";

            case '\u201D':
                return "&rdquo;";

            case '\u201E':
                return "&bdquo;";

            case '\u2020':
                return "&dagger;";

            case '\u2021':
                return "&Dagger;";

            case '\u2030':
                return "&permil;";

            case '\u2039':
                return "&lsaquo;";

            case '\u203A':
                return "&rsaquo;";

            case '\u20AC':
                return "&euro;";

            default:
                return String.valueOf( c );
        }
    }

}
