/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.utils.dao.AbstractPropertyFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * This class is the JNDI names storage for QueWeb Core.
 * Any changes here should be reflected in the J2EE deployment descriptors.
 *
 * @author [ALB] Baranov Andrey
 * @author [ONZ] Oleg N. Zhovtanyuk
 * @version $Revision: 1.3 $ $Date: 2006/01/20 15:19:10 $
 */
public class JNDINames {

    // =============================================================== Constants

    // Resource properties file.
    private static final String FILE_NAME = "rc.properties";

    // Current class.
    private static final Class CLASS = JNDINames.class;

    // ========================================================== Initialization

    // Load JNDI properties.
    private static final Properties props = new Properties();

    static {
        InputStream is = AbstractPropertyFactory.loadSysPropertiesAsStream( CLASS, FILE_NAME );

        try {
            // load properties
            props.load( is );
        } catch( IOException ex ) {
            ex.printStackTrace();
            throw new GenericSystemException( ex );
        }
    }

    // ==================================================================== EJBs

    public static final String AlertManager = "java:comp/env/ejb/AlertManager";

    public static final String AttachmentManager = "java:comp/env/ejb/AttachmentManager";

    public static final String CaptionManager = "java:comp/env/ejb/CaptionManager";
    public static final String CaptionManagerRemote = "java:comp/env/ejb/remote/CaptionManager";

    public static final String LocalizationManager = "java:comp/env/ejb/LocalizationManager";
    public static final String LocalizationManagerRemote = "java:comp/env/ejb/remote/LocalizationManager";

    public static final String CustomConfigManager = "java:comp/env/ejb/CustomConfigManager";
    public static final String CustomConfigManagerRemote = "java:comp/env/ejb/remote/CustomConfigManager";

    public static final String EntityViewConfigManager = "java:comp/env/ejb/EntityViewConfigManager";
    public static final String EntityViewConfigManagerRemote = "java:comp/env/ejb/remote/EntityViewConfigManager";

    public static final String EQLManager = "java:comp/env/ejb/EQLManager";

    public static final String FocusConfigManager = "java:comp/env/ejb/FocusConfigManager";
    public static final String FocusConfigManagerRemote = "java:comp/env/ejb/remote/FocusConfigManager";

    public static final String GetRecords = "java:comp/env/ejb/GetRecords";

    public static final String History = "java:comp/env/ejb/History";

    public static final String JEOManager = "java:comp/env/ejb/JEOManager";

    public static final String LogManagerRemote = "java:comp/env/ejb/remote/LogManager";

    public static final String LockRecords = "java:comp/env/ejb/LockRecords";

    public static final String LockManager = "java:comp/env/ejb/LockManager";

    public static final String MailManager = "java:comp/env/ejb/MailManager";
    public static final String MailManagerRemote = "java:comp/env/ejb/remote/MailManager";

    public static final String NextKey = "java:comp/env/ejb/NextKey";

    public static final String ReportManager = "java:comp/env/ejb/ReportManager";

    public static final String ScriptManagerRemote = "java:comp/env/ejb/remote/ScriptManager";

    public static final String SetRecords = "java:comp/env/ejb/SetRecords";

    public static final String UserManager = "java:comp/env/ejb/UserManager";

    public static final String UserPropertyManager = "java:comp/env/ejb/UserPropertyManager";
    public static final String UserPropertyManagerRemote = "java:comp/env/ejb/remote/UserPropertyManager";

    public static final String ContextMenuConfigManager = "java:comp/env/ejb/ContextMenuConfigManager";
    public static final String ContextMenuConfigManagerRemote = "java:comp/env/ejb/remote/ContextMenuConfigManager";

    public static final String InboxManager = "java:comp/env/ejb/InboxManager";
    public static final String InboxManagerRemote = "java:comp/env/ejb/remote/InboxManager";

    // ========================================================= Other resources

    public static final String JmsAsyncQueue = getProperty( "jms.AsyncQueue" );
    public static final String JmsLogQueue = getProperty( "jms.LogQueue" );
    public static final String JmsConnectionFactory = getProperty( "jms.QueueConnectionFactory" );

    // ============================================================= Environment

    public static final String ServiceCheckInterval = "java:comp/env/check-interval";
    public static final String ServiceRunInterval = "java:comp/env/run-interval";

    // ========================================================= Private methods

    // Gets the system property by name.
    private final static String getProperty( String name ) {
        String value = ( props == null ) ? null : ( String ) props.get( name );
        if( StringHelper.isEmpty( value ) ) {
            throw new GenericSystemException( "Can't get JNDI name '" + name + "' from file '" + FILE_NAME + "'." );
        }
        return value;
    }

}
