/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils;

/**
 * Utility class for number manipulations.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:16 $
 */

public final class NumberHelper {
    
    
    // ------------------------------------------------------- Constants
    
    // Current class reference.
    private static final Class CLASS = NumberHelper.class;
    
    
    // -------------------------------------------------------- Methods
    
    
    /**
     * Parse number and construct Number object
     * @param s number string
     * @return number object
     * @throws NumberFormatException
     */
    public static Number parseNumber( String s )
    throws NumberFormatException {
        
        Number value = null;
        try {
            value = new Long( s );
            if( value.longValue() < Integer.MAX_VALUE && value.longValue() > Integer.MIN_VALUE )
                value = new Integer( value.intValue() );
            
        } catch (NumberFormatException ex1) {
            try {
                value = new Float( s );
            } catch (NumberFormatException ex2) {
                throw new NumberFormatException( ex2.getMessage() + ". Number '" + s + "'" );
            }
        }
        
        return value;
    }
    
    /**
     * Converts the string into boolean.
     *
     * <p>
     * Rules:
     * <ul>
     *  <li><code>true</code> | <code>1</code> - <b>true</b></li>
     *  <li><code>false</code> | <code>0</code> | null string - <b>false</b></li>
     *  <li>all the rest - exception</li>
     * </ul>
     * </p>
     *
     * @param s the string to convert
     * @return boolean value
     * @throws ParseException
     */
    public static boolean num2bool( Number n ) {       
        boolean value = false;

        if( n != null ) {
            if( n.intValue() == 1 ) {
                value = true;
            }
        }
        return value;
    }
    
} // end of class
