/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.cache;

import com.opensymphony.oscache.base.Cache;

/**
 * <p>OS cache wrapper which exposes some protected methods of super class.</p>
 * @author [ALB] Baranov Andrey
 * @version 1.0
 */

public class OSCacheWrapper
    extends Cache {

    /* (non-Javadoc)
     * @see Cache#
     */
    public OSCacheWrapper( boolean useMemoryCaching,
                           boolean unlimitedDiskCache,
                           boolean overflowPersistence ) {
        super( useMemoryCaching, unlimitedDiskCache, overflowPersistence );
    }

    /* (non-Javadoc)
     * @see Cache#clear
     */
    public void clear() {
        super.clear();
    }

    /* (non-Javadoc)
     * @see Cache#removeEntry
     */
    public void removeEntry( String key ) {
        super.removeEntry( key );
    }
}
