/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.utils.dao;

import com.queplix.core.utils.log.AbstractLogger;

import java.util.Properties;

/**
 * Description.
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public abstract class AbstractDAO
    extends AbstractLogger implements InterfaceDAO {

    protected Properties prop;

    /*
     * No javadoc
     * @see InterfaceDAO#setProperties
     */
    public void setProperties( Properties prop ) {
        this.prop = prop;
    }

    /**
     * Property getter by the <code>name</code>.
     * @param name String
     * @return Object
     */
    public Object getProperty( String name ) {
        return prop == null ? null : prop.get( name );
    }
}
