/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.ejb;

import com.queplix.core.utils.cache.CacheObjectManager;
import com.queplix.core.utils.log.AbstractLogger;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;

/**
 * Facade for all entity EJBs.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:19 $
 */

public abstract class AbstractEntityEJB
    extends AbstractLogger
    implements EntityBean {

    // ------------------------------------------------------- Fields

    /** Entity EJB context. */
    protected EntityContext entityContext;

    // Cache object manager
    private final CacheObjectManager com = new CacheObjectManager();

    // ------------------------------------------------------- Common entity EJB implementation

    /**
     * Load EJB
     */
    public void ejbLoad() {}

    /**
     * Store EJB
     */
    public void ejbStore() {}

    /**
     * Activate EJB
     */
    public void ejbActivate() {}

    /**
     * Passivate EJB
     */
    public void ejbPassivate() {}

    /**
     * Set Entity context (put EJB in pool)
     * @param entityContext Entity context
     */
    public void setEntityContext( EntityContext entityContext ) {
        this.entityContext = entityContext;
    }

    /**
     * Unset entity context (remove EJB from pool)
     */
    public void unsetEntityContext() {
        entityContext = null;
    }

    // ------------------------------------------------------- New features

    /**
     * Gets EJB remote home object.
     * @param jndiName JNDI name
     * @param homeClass home class
     * @return remote home object
     */
    protected Object getRemoteHome( String jndiName,
                                    Class homeClass ) {
        try {
            return com.getRemoteHome( jndiName, homeClass );
        } catch( Exception ex ) {
            throw new EJBException( "Can't get remote home '" + jndiName + "'", ex );
        }
    }

    /**
     * Gets EJB local home object.
     * @param jndiName JNDI name
     * @param homeClass home class
     * @return local home object
     */
    protected Object getLocalHome( String jndiName,
                                   Class homeClass ) {
        try {
            return com.getLocalHome( jndiName, homeClass );
        } catch( Exception ex ) {
            throw new EJBException( "Can't get local home '" + jndiName + "'", ex );
        }
    }

} // end of class
