/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.sql.generic;

import com.queplix.core.utils.sql.parser.MemoParser;

import java.io.CharArrayReader;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Generic MEMO data parser.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:21 $
 */

public class MemoParserImpl
    implements MemoParser {

    /* (non-Javadoc)
     * @see SqlTypeParser#getObject(ResultSet, int)
     */
    public final Object getObject( ResultSet rs, int i )
        throws SQLException {

        return getValue( rs, i );
    }

    /* (non-Javadoc)
     * @see SqlTypeParser#getObject(CallableStatement, int)
     */
    public final Object getObject( CallableStatement cs, int i )
        throws SQLException {

        return getValue( cs, i );
    }

    /* (non-Javadoc)
     * @see SqlTypeParser#setObject(PreparedStatement, int, Object)
     */
    public final void setObject( PreparedStatement stat, int pos, Object data )
        throws SQLException {

        if( data != null && ! ( data instanceof char[] ) )
            throw new IllegalStateException( "Only chars supports" );

        setValue( stat, pos, ( char[] ) data );
    }

    /* (non-Javadoc)
     * @see MemoParser#getValue(ResultSet, int)
     */
    public char[] getValue( ResultSet rs, int i )
        throws SQLException {

        char[] value = null;
        String s = rs.getString( i );
        if( !rs.wasNull() )
            value = s.toCharArray();

        return value;
    }

    /* (non-Javadoc)
     * @see MemoParser#getValue(CallableStatement, int)
     */
    public char[] getValue( CallableStatement cs, int i )
        throws SQLException {

        char[] value = null;
        String s = cs.getString( i );
        if( !cs.wasNull() )
            value = s.toCharArray();

        return value;
    }

    /* (non-Javadoc)
     * @see MemoParser#setValue(PreparedStatement, int, char[])
     */
    public void setValue( PreparedStatement stat, int pos, char[] data )
        throws SQLException {

        Reader reader = new CharArrayReader( data );
        stat.setCharacterStream( pos, reader, data.length );
    }

}
