/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.sql.generic;

import com.queplix.core.utils.sql.parser.TimestampParser;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Date;

/**
 * Generic timestamp data parser.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:22 $
 */

public abstract class TimestampParserImpl
    extends DateParserImpl
    implements TimestampParser {

    /* (non-Javadoc)
     * @see TimestampParser#getValue(ResultSet, int)
     */
    public Date getValue( ResultSet rs, int i )
        throws SQLException {

        Date value = null;
        Date date = rs.getTimestamp( i );
        if( !rs.wasNull() ) {
            value = date;
        }
        return value;
    }

    /* (non-Javadoc)
     * @see TimestampParser#getValue(CallableStatement, int)
     */
    public Date getValue( CallableStatement cs, int i )
        throws SQLException {

        Date value = null;
        Date date = cs.getTimestamp( i );
        if( !cs.wasNull() ) {
            value = date;
        }
        return value;
    }

    /* (non-Javadoc)
     * @see TimestampParser#setValue(PreparedStatement, int, Date)
     */
    public void setValue( PreparedStatement stat, int pos, Date data )
        throws SQLException {

        if( data == null ) {
            stat.setNull( pos, Types.TIMESTAMP );
        } else {
            stat.setTimestamp( pos, new java.sql.Timestamp( ( ( Date ) data ).getTime() ) );
        }
    }
}
