/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.sql.vendor.db2;

import com.queplix.core.utils.DateHelper;
import com.queplix.core.utils.sql.generic.TimeParserImpl;

import java.sql.Time;

/**
 * DB2 time parser.
 * @author [ALB] Andrey Baranov
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:22 $
 */

public class TimeParserDB2Impl
    extends TimeParserImpl {

    /* (non-Javadoc)
     * @see TimeParser#sqlTimeFunction(Time)
     */
    public String sqlTimeFunction( Time time ) {
        String timeStr = DateHelper.formatTime( time );
        return "{t '" + timeStr + "'}";
    }
}
