/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.sql.vendor.oracle;

import com.queplix.core.utils.sql.generic.MemoParserImpl;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

/**
 * Oracle memo data parser.
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:23 $
 */

public class MemoParserOracleImpl
    extends MemoParserImpl {

    // OracleClob reference
    protected final OracleClob oc = new OracleClob();

    /* (non-Javadoc)
     * @see MemoParser#getObject(ResultSet, int)
     */
    public char[] getValue( ResultSet rs, int i ) {
        return oc.getObject( rs, i );
    }

    /* (non-Javadoc)
     * @see MemoParser#getObject(CallableStatement, int)
     */
    public char[] getValue( CallableStatement cs, int i ) {
        return oc.getObject( cs, i );
    }

    /* (non-Javadoc)
     * @see MemoParser#setObject(PreparedStatement, int, char[])
     */
    public void setValue( PreparedStatement stat, int pos, char[] data ) {
            oc.setObject( stat, pos, data );
    }
}
