/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.xml;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

/**
 * Translet wrapper interface.
 *
 * @author [BAA] Alexander Balandin
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:25 $
 */
public interface TransletWrapper {

    /**
     * Load XSL template from source
     * @param xslStream InputStream input source
     * @return Templates object
     */
    Templates loadTemplate( InputStream xslStream );

    /**
     * Make XML transformation with XSL stylesheet.
     *
     * @param xslFile XSL stylesheet
     * @param xmlFile XML file
     * @param params XSLT global parameters
     * @return OutputStream
     */
    OutputStream transform( File xslFile, File xmlFile, Map params );

    /**
     * Make XML transformation with XSL translet.
     *
     * @param source XML Source
     * @param result XML Result
     * @param transletName class name of needed translet
     * @param params XSLT global parameters
     */
    void transform( Source source, Result result, String transletName, Map params );

    /**
     * Make XML transformation with XSL translet.
     *
     * @param source XML Source
     * @param result XML Result
     * @param templates Templates object
     * @param params XSLT global parameters
     */
    void transform( Source source, Result result, Templates templates, Map params );

}
