/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.utils.xml.impl.v26;

import com.queplix.core.error.GenericSystemException;
import com.queplix.core.utils.xml.DefaultSAXErrorHandler;
import com.queplix.core.utils.xml.XMLWrapper;
import org.apache.xalan.xsltc.compiler.Constants;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;

/**
 * <p>XML wrapper implementation for Xalan 2.6</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:27 $
 */

public class XalanXMLWrapper
    implements XMLWrapper {

    // ----------------------------------------------------- public methods

    /*
     * No javadoc
     * @see XMLWrapper#getDOMParser(boolean)
     */
    public DocumentBuilder getDOMParser( boolean validate ) {

        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware( true );
        dbf.setValidating( validate );
        if( validate ) {
            dbf.setAttribute( "http://java.sun.com/xml/jaxp/properties/schemaLanguage",
                              "http://www.w3.org/2001/XMLSchema" );
        }

        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        } catch( ParserConfigurationException ex ) {
            throw new GenericSystemException( "Cannot create new XML parser", ex );
        }

        db.setErrorHandler( new DefaultSAXErrorHandler() );
        return db;

    }

    /*
     * No javadoc
     * @see XMLWrapper#getSAXParser(boolean)
     */
    public SAXParser getSAXParser( boolean validate ) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature( Constants.NAMESPACE_FEATURE, true );
        } catch( Exception e ) {
            factory.setNamespaceAware( true );
        }

        SAXParser parser = null;
        try {
            parser = factory.newSAXParser();

        } catch( ParserConfigurationException e ) {
            throw new GenericSystemException( "SAX Parser is not configured properly.", e );

        } catch( SAXException e ) {
            throw new GenericSystemException( "SAX Parser could not be created.", e );
        }

        return parser;
    }

    /*
     * No javadoc
     * @see XMLWrapper#getDocument(InputStream,boolean)
     */
    public Document getDocument( InputStream in, boolean validate ) {
        DocumentBuilder db = getDOMParser( validate );
        try {
            return db.parse( in );
        } catch( Exception ex ) {
            throw new GenericSystemException( "Cannot parse XML source: " +
                                              ex.getMessage(), ex );
        }
    }

    /*
     * No javadoc
     * @see XMLWrapper#getDocument(Reader,boolean)
     */
    public Document getDocument( Reader in, boolean validate ) {
        DocumentBuilder db = getDOMParser( validate );
        try {
            return db.parse( new InputSource( in ) );
        } catch( Exception ex ) {
            throw new GenericSystemException( "Cannot parse XML source: " +
                                              ex.getMessage(), ex );
        }
    }

    /*
     * No javadoc
     * @see XMLWrapper#getDocument(File,boolean)
     */
    public Document getDocument( File f, boolean validate ) {
        DocumentBuilder db = getDOMParser( validate );
        try {
            return db.parse( f );
        } catch( Exception ex ) {
            throw new GenericSystemException( "Cannot parse XML source: " +
                                              ex.getMessage(), ex );
        }
    }
}
