/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui;

/**
 * Represents data for any kind of button.
 * @author Sultan Tezadov
 * @since 25 Nov 2006, 11:20
 */
public class ButtonData extends IconData {
    private String caption;
    private String disabledIcon;
    private String brightIcon;
    private String captionStyle;
    private String captionHoverStyle;
    private String captionSelectedStyle;
    
    public static final int OK = 0x00000001;
    public static final int CANCEL = 0x00000002;
    public static final int SEND_MAIL = 0x00000004;
    public static final int CANCEL_MAIL = 0x00000008;
    private int button_id;
    
    /**
     * Constructor
     * @param caption item's caption
     */
    public ButtonData(String caption) {
        this(caption, null);
    }
    
    public ButtonData(String caption, String title) {
        this(caption, title, null);
    }
    
    public ButtonData(String caption, String title, String icon) {
        this(caption, title, icon, null);
    }
    
    public ButtonData(String caption, String title, String icon, String disabledIcon) {
        this(caption, title, icon, disabledIcon, null);
    }
    
    public ButtonData(String caption, String title, String icon, String disabledIcon, String brightIcon) {
        this(caption, title, icon, disabledIcon, brightIcon, false);
    }
    
    public ButtonData(String caption, String title, String icon, String disabledIcon, String brightIcon, int button_id) {
        this(caption, title, icon, disabledIcon, brightIcon, false);
        this.button_id = button_id;
    }
    
    public ButtonData(String caption, String title, String icon, String disabledIcon, String brightIcon, boolean style) {
        super(icon, title, style);
        this.caption = caption;
        this.disabledIcon = disabledIcon;
        this.brightIcon = brightIcon;
    }
    
    public int getButtonId() {
        return button_id;
    }
    
    public String getDisabledIcon() {
        return disabledIcon;
    }
    
    public void setDisabledIcon(String disabledIcon) {
        this.disabledIcon = disabledIcon;
    }

    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getBrightIcon() {
        return brightIcon;
    }

    public void setBrightIcon(String brightIcon) {
        this.brightIcon = brightIcon;
    }

    public String getCaptionStyle() {
        return captionStyle;
    }

    public void setCaptionStyle(String captionStyle) {
        this.captionStyle = captionStyle;
    }

    public void setCaptionHoverStyle(String captionHoverStyle) {
        this.captionHoverStyle = captionHoverStyle;
    }

    public void setCaptionSelectedStyle(String captionSelectedStyle) {
        this.captionSelectedStyle = captionSelectedStyle;
    }

    public String getCaptionHoverStyle() {
        return captionHoverStyle;
    }

    public String getCaptionSelectedStyle() {
        return captionSelectedStyle;
    }

    public boolean hasCaptionHoverStyle() {
        return (captionHoverStyle != null);
    }

    public boolean hasCaptionStyle() {
        return (captionStyle != null);
    }

    public boolean hasCaptionSelectedStyle() {
        return (captionSelectedStyle != null);
    }
}