/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui;

import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Panel;

/**
 * Frame Links.
 * @author Sultan Tezadov
 * @since 7 Dec 2006
 */
public class FrameLinks extends LabelButtonSet {
    private static final String CORNER_IMAGE_PATH = "common/upper_menu_left.gif";
    private static final String BUTTON_PANEL_STYLE = "upper_menu";

    private HorizontalPanel panel;
    
    public FrameLinks() {
        super(true, false);
        panel = new HorizontalPanel();
        Panel buttonPanel = super.getPanel();
        panel.add(new Image(CORNER_IMAGE_PATH));
        panel.add(buttonPanel);
        panel.setSpacing(0);
        buttonPanel.setStyleName(BUTTON_PANEL_STYLE);
        initWidget(panel);
    }
}
