/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.common.ui;

import java.util.Iterator;
import java.util.Vector;

/**
 *
 * @author v.mikhailitchenko
 * @since 15.11.2006
 */
public class TabMouseListenerCollection extends Vector {
    public void fireTabMouseOver(SourcesTabMouseEvents sender, int tabIndex) {
        for (Iterator it = iterator(); it.hasNext();) {
            TabMouseListener listener = (TabMouseListener) it.next();
            listener.onTabMouseOver(sender, tabIndex);
        }
    }
    
    public void fireTabMouseOut(SourcesTabMouseEvents sender, int tabIndex) {
        for (Iterator it = iterator(); it.hasNext();) {
            TabMouseListener listener = (TabMouseListener) it.next();
            listener.onTabMouseOut(sender, tabIndex);
        }
    }
}
