/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.common.ui.grid;

import java.util.ArrayList;

/**
 * This grid doesn't select records by itself, but sends confirmation event
 * instead.
 *
 * @author Sergey Kozmin
 * @since 30.03.2007
 */
class ConfirmableInternalGrid extends SelectianableInternalGrid{
    protected ConfirmableInternalGrid(GridView view,
                                      GridElementsStrategy strategy,
                                      ArrayList gridListeners) {
        super(view, strategy, gridListeners);
    }

    protected void setRowSingleSelected(int row, boolean generateEvents) {
        if(generateEvents) {
            Events.GRID_ROW_TO_BE_SELECTED.setData(new Integer(row));
            getEventSource().fireEvent(Events.GRID_ROW_TO_BE_SELECTED);
        } else {
            super.setRowSingleSelected(row, generateEvents);
        }
    }
}
