/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui.grid;

/**
 * DataGridColumns - DataGridMeta items
 * @author Vasily Mikhailitchenko
 * @since 19 Dec 2006
 */
public class DataGridColumn {
    public static final int MINIMAL_WIDTH = 10;
    public static final int SIZE_UNSPECIFIED = -1;
    
    private long id;
    private String caption;
    private int width;
    private boolean resized;
    
    public DataGridColumn() {
    }

    public DataGridColumn(long id, String caption, int width) {
        this.id = id;
        this.caption = caption;
        this.width = width;
    }
    
    public DataGridColumn(long id, String caption){
        this(id, caption, SIZE_UNSPECIFIED);
    }

    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public long getID() {
        return id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean isResized() {
        return resized;
    }

    public void setResized(boolean resized) {
        this.resized = resized;
    }
    
}
