/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui.grid;

import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.client.app.vo.GridMeta;
import com.queplix.core.client.app.vo.uisettings.GridUISettings;

import java.util.Map;


/**
 * DataGrid-related metadata
 * @author Vasily Mikhailitchenko
 * @since 19 Dec 2006
 */
public class DataGridMetaImpl implements DataGridMeta {
    private DataGridColumn[] columns;
    
    public DataGridMetaImpl() {
    }

    public DataGridColumn[] getColumns() {
        return columns;
    }

    public void setColumns(DataGridColumn[] columns) {
        this.columns = columns;
    }
    
    public String getCaption(int column){
        return columns[column].getCaption();
    }
    
    public int getColumnIndex(long columnID) {
        int i = columns.length - 1;
        while ((i > -1)  &&  (columns[i].getID() != columnID)) {
            i--;
        }
        return i;
    }

    public DataGridColumn getColumn(int column) {
        return columns[column];
    }

    public int getColumnsCount() {
        return columns.length;
    }

    public static DataGridMeta createDataGridMeta(FieldMeta[] fieldMetas) {
        DataGridMetaImpl result = new DataGridMetaImpl();

        DataGridColumn[] dataGridColumns = new DataGridColumn[fieldMetas.length];
        for(int i = 0; i < fieldMetas.length; i++) {
            FieldMeta fieldMeta = fieldMetas[i];
            String caption = fieldMeta.getCaption();
            dataGridColumns[i] = new DataGridColumn(i, caption);
        }
        result.setColumns(dataGridColumns);
        return result;
    }

    public static DataGridMeta createDataGridMeta(GridMeta meta) {
        DataGridMetaImpl result = new DataGridMetaImpl();
        FieldMeta[] fieldMetas = meta.getFields();

        long[] ids = meta.getColumns().getSelectedIDs();
        DataGridColumn[] dataGridColumns = new DataGridColumn[ids.length];
        for (int i = 0; i < ids.length; i++) {
            int id = (int) ids[i];
            FieldMeta fieldMeta = fieldMetas[id];
            String caption = fieldMeta.getCaption();
            dataGridColumns[i] = new DataGridColumn(id, caption);

            GridUISettings uiSettings = meta.getUISettings();
            if (uiSettings != null) {
                Map columnWidths = uiSettings.getColumnWidths();
                if (columnWidths != null) {
                    Integer width = (Integer) columnWidths.get(fieldMeta.getFieldID());
                    if (width != null) {
                        dataGridColumns[i].setResized(true);
                        dataGridColumns[i].setWidth(width.intValue());
                    }
                }
            }
        }
        result.setColumns(dataGridColumns);
        return result;
    }

    public static DataGridMeta createDataGridMeta(DataGridMeta oldMeta, GridMeta meta) {
        DataGridMeta newMeta = createDataGridMeta(meta);
        for (int i = 0; i < oldMeta.getColumnsCount(); i++) {
            DataGridColumn oldColumn = oldMeta.getColumn(i);
            long id = oldColumn.getID();
            int index = newMeta.getColumnIndex(id);
            if (index > -1) { // found
                newMeta.getColumn(index).setWidth(oldColumn.getWidth());
            }
        }
        return newMeta;
    }

    public static void collectUISettings(DataGridMeta dataGridColumns, GridMeta meta) {
        FieldMeta[] fieldMetas = meta.getFields();

        long[] ids = meta.getColumns().getSelectedIDs();
        for (int i = 0; i < ids.length; i++) {
            if (dataGridColumns.getColumn(i).isResized()) {
                int id = (int) ids[i];
                FieldMeta fieldMeta = fieldMetas[id];
                String key = fieldMeta.getFieldID();
                Integer width = new Integer(dataGridColumns.getColumn(i).getWidth());
                Map columnWidths = meta.getOrCreateColumnWidths();
                columnWidths.put(key, width);
            }
        }
    }
}
