/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.common.ui.resizable;

import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.common.StringUtil;
import com.queplix.core.client.common.ui.*;

/**
 * Enforces proper resizing for the wrapped child that implements Resizable.
 * If the wrapped child does not correctly set the requested size, this
 * class will guaranteely set its own size to the requested value even
 * in cases when it causes the wrapped child being cut off.
 * 
 * @author Sultan Tezadov
 * @since 28 Dec 2006
 */
public class ResizableEnforcer extends Composite implements Resizable {
    AbsolutePanel panel;
    private Resizable child;
    
    public ResizableEnforcer(Resizable widget) {
        if (! (widget instanceof Widget)) {
            throw new IllegalArgumentException("Illegal argument: widget." +
                    " Must be an instance of Widget");
        }
        panel = new AbsolutePanel();
        this.child = widget;
        panel.add((Widget) widget);
        initWidget(panel);
    }

    public void setOffsetHeight(int height) {
        height = (height > 0) ? height : 0;
        child.setOffsetHeight(height);
        panel.setHeight(StringUtil.pixelToSize(height));
    }

    public void setOffsetWidth(int width) {
        width = (width > 0) ? width : 0;
        child.setOffsetWidth(width);
        panel.setWidth(StringUtil.pixelToSize(width));
    }
    
}
