/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls;

import com.queplix.core.client.common.event.EventSource;

/**
 * That class determine the base functional, that should implement each element, placed in QForm component.
 *
 * @author Sergey Kozmin
 * @since 08.11.2006, 18:24:39
 */
public interface QFormElementController {
    /**
     * Set datalistener to be notified about control data requirements.
     * @param listener data listener 
     */
    public void setDataRequirementsListener(DataRequirementsListener listener);
    
    public EventSource getEventSource();

    public void collectUISettings();
}
