/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls;

import com.queplix.core.client.app.vo.uisettings.DialogUISettings;
import com.queplix.core.client.common.event.EventSource;

/**
 * That class is the default implementation of {@link QFormElementController}.
 * It doesn't allow you to store nullable
 * control id, and store protected listener in it.
 * @author Sergey Kozmin
 * @since 8 Nov 2006
 */
public abstract class QFormElementControllerImpl implements QFormElementController {
    // -------------------- public events ------------------------
    public static interface Events extends QFormElementView.Events {}
    public EventSource getEventSource() {
        return getView().getEventSource();
    }
    // ----------------- end of public events --------------------
    
    protected DataRequirementsListener dataRequestListener;
    
    public void setDataRequirementsListener(DataRequirementsListener listener) {
        this.dataRequestListener = listener;
    }
    
    public void collectUISettings() {
        DialogUISettings uiSettings = getView().getUISettings();
        getModel().getBaseMeta().setUISettings(uiSettings);
    }
    
    protected abstract QFormElementModel getModel();
    protected abstract QFormElementView getView();
}
