/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls;

import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.client.app.vo.FieldOnDemandData;

/**
 * Represent base interface for widget model.
 *
 * @author Sergey Kozmin
 * @since 21 Sep 2006
 */
public interface QFormElementModel {
    public final static int DISABLED_FOR_REPORT_DESIGN = 0;
    public final static int NOT_IN_REPORT = 1;
    public final static int IN_REPORT = 2;

    /**
     * @return true if control capable to be link (to another entity)
     * @see com.queplix.core.client.app.vo.FieldType
     */
    public boolean isLinkable();
    /**
     * @return true if control was described as required
     * @see com.queplix.core.client.app.vo.FieldType
     */
    public boolean isValid();

    /**
     * @return correct error message, if {@link #isValid()} return false.
     */
    public String getErrorTitle();

    /**
     * @return report design mode add or delete
     */
    public int getReportDesignState();

    /**
     * sets report design mode add or delete
     * @param data design state
     * @see #DISABLED_FOR_REPORT_DESIGN, #NOT_IN_REPORT, #IN_REPORT
     */
    public void setReportDesignState(int data);

    public void setCaption(String caption);
    
    public FieldMeta getBaseMeta();
    public void setBaseMeta(FieldMeta meta);
    public FieldData getBaseData();
    public void setBaseData(FieldData data);

    public void setFieldOnDemandData(FieldOnDemandData onDemandData);

    /**
     * Returns type of the data.
     * @return type of data.
     * @see com.queplix.core.client.app.vo.FieldType
     */
    public int getDataType();

    /**
     * Clone all the data from the widget which has the same type of data
     * @param sameTypeControlModel widget to be cloned
     * @throws DataCloneException to be thrown when client is trying to clone widget data
     * from inappropriate type of widget 
     */
    public void cloneDataFrom(QFormElementModel sameTypeControlModel) throws DataCloneException;

}
