/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.chart;

import com.queplix.core.client.app.vo.chart.ChartData;
import com.queplix.core.client.app.vo.chart.ChartMeta;
//import com.queplix.core.client.app.vo.chart.ChartModel;

/**
 * Chart control model
 * @author Michael Trofimov
 */
public interface QChartModel /*extends ChartModel*/ {

    static interface ModelListener {
        void onMetaChanged();
        void onDataChanged();
    }

    void addListener(ModelListener listener);

    /**
     * Returns chart metadata object.
     */
    public ChartMeta getMeta();

    /**
     * Sets chart metadata object.
     */
    void setMeta(ChartMeta meta);
    
    /**
     * Returns chart data object.
     */
    public ChartData getData();

    /**
     * Sets chart data object.
     */
    void setData(ChartData data);

}
