/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.checkbox;

import com.queplix.core.client.app.vo.CheckBoxMeta;
import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;

/**
 * Class represents Checkbox widget component.
 * @author Vasily Mikhailitchenko
 * @since 15.09.2006
 */
public class QCheckBox implements QFormElement {
    private QCheckBoxControllerImpl controller;
    private QCheckBoxViewImpl view;
    private QCheckBoxModelImpl model;

    public QCheckBox(CheckBoxMeta element, int layout) {
        model = new QCheckBoxModelImpl(element);
        view = new QCheckBoxViewImpl(model, layout);
        controller = new QCheckBoxControllerImpl(view, model);
    }

    public QCheckBoxModel getModel() {
        return model;
    }

    public QCheckBoxView getView() {
        return view;
    }

    public QCheckBoxController getController() {
        return controller;
    }

    public QFormElementModel getBaseModel() {
        return model;
    }

    public QFormElementView getBaseView() {
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }
}
