/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.checkbox;

import com.queplix.core.client.app.vo.CheckBoxData;
import com.queplix.core.client.app.vo.CheckBoxMeta;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

/**
 * Checkbox component data
 *
 * @author Vasily Mikhailitchenko
 * @since 15.09.2006
 */
class QCheckBoxModelImpl extends QFormElementModelImpl implements QCheckBoxModel {
    public QCheckBoxModelImpl(CheckBoxMeta element) {
        setMeta(element);
        setData(new CheckBoxData());
    }

    public CheckBoxMeta getMeta() {
        if(null == super.getBaseMeta()) {
            setMeta(new CheckBoxMeta());
        }
        return (CheckBoxMeta) getBaseMeta();
    }

    public void setMeta(CheckBoxMeta meta) {
        setBaseMeta(meta);
    }

    public CheckBoxData getData() {
        if(null == getBaseData()) {
            setData(new CheckBoxData());
        }
        return ((CheckBoxData) getBaseData());
    }

    public void setData(CheckBoxData data) {
        setBaseData(data);
    }

    public boolean isValid() {
        return !(getMeta().isRequired() && getData().isEmpty());
    }

    public int getDataType() {
        return THE_TYPE;
    }

    public void cloneDataFrom(QFormElementModel sameTypeControlModel) throws DataCloneException {
        if(THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel.getDataType());
        }
        QCheckBoxModel model = (QCheckBoxModel) sameTypeControlModel;
        setData((CheckBoxData) model.getData().cloneData());
    }

    public boolean isLinkable() {
        return false;
    }
}
