/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.datefield;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Button;
import java.util.ArrayList;

/**
 * Button wich can catch right button click event.
 * @author Alexander Melnik
 * @since 23 march 2007
 */
public class ButtonWithRightClick extends Button {
    private ArrayList rightClickListeners = new ArrayList();
    
    public ButtonWithRightClick(String buttonValue) {
        super(buttonValue);
        sinkEvents(Event.MOUSEEVENTS);
    }
    
    public void addRightClickListener(MouseRightClickListener listener) {
        rightClickListeners.add(listener);
    }
    
    public void removeRightClickListener(MouseRightClickListener listener) {
        rightClickListeners.remove(listener);
    }
    
    private void fireRightClick() {
        for(int i=0; i<rightClickListeners.size(); i++) {
            ((MouseRightClickListener) rightClickListeners.get(i)).onRightClick(this);
        }
    }
    
    public void onBrowserEvent(Event event) {
        int type = DOM.eventGetType(event);
        if(type == Event.ONMOUSEDOWN) {
            if(DOM.eventGetButton(event) == Event.BUTTON_RIGHT) {
                fireRightClick();
                return;
            }
        }
        super.onBrowserEvent(event);
    }
    
}
