/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.datefield;

import com.queplix.core.client.app.rpc.RPC;
import com.queplix.core.client.app.vo.ParseDateRequestObject;
import com.queplix.core.client.app.vo.ParseDateResponseObject;
import com.queplix.core.client.common.ui.DialogHelper;
import java.util.Date;

/**
 * Date Parser.
 * @author Aliaksandr Melnik
 * @since 22 Nov 2006
 */
public class DateParser {
    
    private ParseDateRequestObject request = new ParseDateRequestObject();
    
    private DataParserListener dataParserListener;//only one listener
    
    public void addDataParserListener(DataParserListener listener) {
        dataParserListener = listener;
    }
    
    public DateParser() {
    }
    
    public void parse(String stringToParse) {
        request.setStringToParse(stringToParse);
        RPC.QAsyncCallback callback = new ParseDateAsyncCallback();
        RPC.getRPC().parseDate(request, callback);
    }
    
    private class ParseDateAsyncCallback extends RPC.QAsyncCallback {
        public void onRequestEnded(boolean success, Object result) {
            if(success) {
                ParseDateResponseObject pdro = (ParseDateResponseObject) result;
                if(pdro.isSuccessful()) {
                    if(!pdro.isInterval()) {
                        dataParserListener.parsed(pdro.getStartDate());
                    } else {
                        dataParserListener.parsed(pdro.getStartDate(), pdro.getEndDate());
                    }
                } else {
                    dataParserListener.parseFailed();
                }
            } else {
                dataParserListener.parseFailed();
                DialogHelper.showModalMessageDialog("Parse Date Request Failed.");
            }
        }
    }
    
    public interface DataParserListener {
        public void parsed(Date date);
        public void parsed(Date startDate, Date endDate);
        public void parseFailed();
    }
    
}
