/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.datefield;

import com.queplix.core.client.app.vo.DateFieldData;
import com.queplix.core.client.app.vo.DateFieldMeta;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

import java.util.Date;

/**
 * Date field component data
 *
 * @author Sergey Kozmin
 * @since 14.09.2006, 19:09:29
 */
class QDateFieldModelImpl extends QFormElementModelImpl implements QDateFieldModel {
    public QDateFieldModelImpl(DateFieldMeta dateFieldMeta) {
        setMeta(dateFieldMeta);
        setData(new DateFieldData("", null, new Date(), ""));
    }

    public DateFieldMeta getMeta () {
        if (null == super.getBaseMeta()) {
            setMeta(new DateFieldMeta());
        }
        return (DateFieldMeta) super.getBaseMeta();
    }
    
    public void setMeta(DateFieldMeta meta) {
        super.setBaseMeta(meta);
    }

    public DateFieldData getData () {
        if(null == super.getBaseData()) {
            setData(new DateFieldData("", null, new Date(), ""));
        }
        return ((DateFieldData) super.getBaseData());
    }
        
    public void setData(DateFieldData data) {
        super.setBaseData(data);
    }
   
    public boolean isValid() {
        return !(getMeta().isRequired() && null == getData().getStartDate());
    }
    
    public int getDataType() {
        return THE_TYPE;
    }
    
    public void cloneDataFrom(QFormElementModel sameTypeControlModel) throws DataCloneException {
        if(THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel.getDataType());
        }
        QDateFieldModel model = (QDateFieldModel) sameTypeControlModel;
        this.setData((DateFieldData) model.getData().cloneData());
        setCaption(model.getMeta().getCaption());
    }

    public boolean isLinkable() {
        return false;
    }
    
}
