/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.form;

import com.queplix.core.client.frames.mainframe.FormState;

/**
 * Handle event: have new record been prepared. If so, turn to new state otherwise do nothing.
 *
 * @author Sergey Kozmin
 * @since 02.10.2006, 18:39:27
 */
class NewUnit extends BaseChainUnit {
    private ChainUnitContext unitContext;

    public NewUnit(ChainUnitContext unitContext) {
        this.unitContext = unitContext;
    }

    public boolean isAccepted(int event) {
        return event == NEW_SUCCESSFUL || event == NEW_FAILED;
    }

    public void handleEvent(int event) throws IncorrectFormActionPerformed {
        switch(event) {
            case NEW_SUCCESSFUL: {
                unitContext.changeState(FormState.NEW_STATE);
                break;
            }
        }
    }

    public String getName() {
        return "New unit";
    }
}
