/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.form;

import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.event.EventSource;
import com.queplix.core.client.controls.QFormElementView;
/*]import com.queplix.core.client.controls.form.event.FormMenuEventData;[*/

/**
 * Interface for the QueWeb QForm widget controller
 * @author Sergey Kozmin
 * @since 21 Sep 2006
 */
// TODO: once generics enabled, remove all occurences of '/*]' and '[*/'
public interface QFormController {
    public final static String FORM_SEARCH_BUTTON = "FORM_SEARCH_BUTTON";
    public final static String FORM_CLEAR_BUTTON = "FORM_CLEAR_BUTTON";
    public final static String FORM_NEW_BUTTON = "FORM_NEW_BUTTON";
    public final static String FORM_CHANGE_BUTTON = "FORM_CHANGE_BUTTON";
    public final static String FORM_UPDATE_BUTTON = "FORM_UPDATE_BUTTON";
    public final static String FORM_CHANGE_OR_UPDATE_BUTTON = "FORM_CHANGE_OR_UPDATE_BUTTON";
    // -------------------- public events ------------------------
    public static interface Events {
        /**
         * Form menu item selected event.
         * Event data passed along with it is of type String
         */
        Event/*]<String>[*/ FORM_MENU_ITEM = new Event/*]<String>[*/();

        /**
         * Form custom button clicked event.
         * Event data passed along with it is of type String
         */
        Event/*]<String>[*/ FORM_CUSTOM_BUTTON = new Event/*]<String>[*/();

        Event LINKED_FORM_SELECTION_EVENT = QFormElementView.Events.LINKED_FORM_SELECTION_EVENT;

        Event/*]<FieldMeta>[*/ FORM_ELEMENT_REPORT_DESIGN_EVENT = new Event/*]<FieldMeta>[*/();

        Event/*]<FormStateChangedData>[*/ FORM_STATE_CHANGED_EVENT = new Event/*]<FormStateChangedData>[*/();

        Event/*]<FieldDataRequest>[*/ FORM_CONTROL_NEED_MORE_DATA_EVENT = new Event/*]<FieldDataRequest>[*/();

        Event/*]<FamgMeta.Index>[*/ FORM_SELECTION_REQUESTED_EVENT = new Event/*]<FamgMeta.Index>[*/();
        
        Event FORM_SEARCH_BUTTON_EVENT = new Event(FORM_SEARCH_BUTTON);
        Event FORM_CLEAR_BUTTON_EVENT = new Event(FORM_CLEAR_BUTTON);
        Event FORM_NEW_BUTTON_EVENT = new Event(FORM_NEW_BUTTON);
        Event FORM_CHANGE_BUTTON_EVENT = new Event(FORM_CHANGE_BUTTON);
        Event FORM_UPDATE_BUTTON_EVENT = new Event(FORM_UPDATE_BUTTON);
    }

    public EventSource getEventSource();
    // ----------------- end of public events --------------------

    public void clearForm();
    /**
     * Set state of form. States can be found {@link com.queplix.core.client.controls.form.QFormState}
     * @see com.queplix.core.client.controls.form.QFormState
     * @param formState state to set
     * @throws IncorrectFormStateSelected if incorrect form state selected
     * @return was form turned to new state or not.
     */
    public boolean setFormState(int formState) throws IncorrectFormStateSelected;

    /**
     * This method finalize all waitings processes, reset form state to initial and set form to the given state.
     * @param formState state to set
     * @throws IncorrectFormStateSelected if incorrect form state selected 
     */
    public void resetAndSetFormState(int formState) throws IncorrectFormStateSelected;

    public boolean canFormChangeState();
    
    public void searchByPkey(Long pkey);

    public void searchByData(FieldData[] fieldData);

    public void initFormElementsData();

    public void whenScrolling();

    public void collectUISettings();
    
    public void onTabActivated();

    /**
     * Inject event of type {@link com.queplix.core.client.controls.form.QFormController.Events}
     * @param commonButtonIndex the event
     */
    public void performAction(Event commonButtonIndex);
    
    public int getCurrentState();

    public String getRecordEditingMessage();
}
