/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.history;

import com.queplix.core.client.app.vo.HistoryFieldMeta;
import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;

/**
 * @author: Melnik Alexander
 * @since: 11.01.2007
 */
public class QHistory implements QFormElement {
    public static final String BUTTON_EMPTY_IMAGE_PATH = "memo/button1.gif";
    public static final String BUTTON_FULL_IMAGE_PATH = "memo/button2.gif";
    
    public static final String BUTTON_CSS_STYLE = "simple_button";
    
    public static final int DEFAULT_WIDTH = 15;
    public static final int DEFAULT_HEIGHT = 4;

    private QHistoryModelImpl model;
    private QHistoryViewImpl view;
    private QHistoryControllerImpl controller;

    public QHistory(HistoryFieldMeta element) {
        // setting some draggable caption
        model = new QHistoryModelImpl(element);
        view = new QHistoryViewImpl(model, QFormElement.HORIZONTAL);
        controller = new QHistoryControllerImpl(model, view);
    }

    public QHistoryModel getModel(){
        return model;
    }

    public QHistoryController getController() {
        return controller;
    }

    public QFormElementView getBaseView(){
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }

    public QFormElementModel getBaseModel(){
        return model;
    }
}

