/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.informgrid;

import com.queplix.core.client.controls.QFormElementView;

/**
 * Abstract class for all inform grid states, contains base implementation of
 * useful functions
 *
 * @author Sergey Kozmin
 * @since 29.03.2007
 */
abstract class AbstractState implements QInformGridState {
    protected StateContext context;
    private int state;

    protected AbstractState(StateContext context, int state) {
        this.context = context;
        this.state = state;
    }

    protected void changeStateIfAnother() throws IncorrectGridActionPerformed {
        int newState = getInternalState(context.getControlState());
        if(newState != getState()) {
            context.changeState(newState);
        }
    }

    protected int getInternalState(int controlState)
            throws IncorrectGridActionPerformed {
        switch(controlState) {
            case QFormElementView.MODE_NEW : //don't break here
            case QFormElementView.MODE_EDIT : return QInformGridState.EDIT_STATE;
            case QFormElementView.MODE_REPORT_DESIGN : //don't break here
            case QFormElementView.MODE_DISABLED : return QInformGridState.SELECTED_STATE;
            case QFormElementView.MODE_SEARCH : return QInformGridState.SEARCH_STATE;
            default : throw new IncorrectGridActionPerformed("Coldn't handle QFormElementView mode [" + controlState + "].");
        }
    }

    public int getState() {
        return state;
    }

    public void exitFromState() {
    }
}
