/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.multiselect;

import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;
import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.client.app.vo.MultiselectFieldMeta;

/**
 * Multi Select Control
 *
 * @author Rustem Nizamiev
 * @since 14.09.2006, 19:25:09
 */

public class QMultiSelect implements QFormElement {
    public static final String BUTTON_EMPTY_IMAGE_PATH = "multiselect/icon.gif";
    public static final String BUTTON_FULL_IMAGE_PATH = "multiselect/icon_full.gif";
    public static final String BUTTON_CSS_STYLE = "simple_button";

    public final static String MS_STYLE_NAME_PREFIX = "multiselect_";
    private QMultiSelectControllerImpl controller;
    private QMultiSelectViewImpl view;
    private QMultiSelectModelImpl model;

    public QMultiSelect(MultiselectFieldMeta fieldMeta) {
        model = new QMultiSelectModelImpl(fieldMeta);
        view = new QMultiSelectViewImpl(model);
        controller = new QMultiSelectControllerImpl(view, model);
    }

    public QMultiSelectController getController() {
        return controller;
    }

    public QMultiSelectModel getModel() {
        return model;
    }

    public QMultiSelectView getView() {
        return view;
    }

    public QFormElementModel getBaseModel() {
        return model;
    }

    public QFormElementView getBaseView() {
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }

}
