/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.multiselect;

public class QMultiSelectElement {
    private boolean state;
    private String caption;
    private int idNum;

    public QMultiSelectElement(boolean state, int id, String caption) {
        this.state = state;
        this.caption = caption;
        this.idNum = id;
    }

    public String getCaption() {
        return caption;
    }

    void setCaption(String text) {
        this.caption = text;
    }

    int getIdNum() {
        return idNum;
    }

    void setIdNum(int id) {
        this.idNum = id;
    }

    public boolean getState() {
        return state;
    }

    public void setState(boolean st) {
        state = st;
    }

    void invertState() {
        state = !state;
    }
}