/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.controls.multiselect;

import com.queplix.core.client.app.vo.FieldOnDemandData;
import com.queplix.core.client.app.vo.MultiselectFieldData;
import com.queplix.core.client.app.vo.MultiselectFieldMeta;
import com.queplix.core.client.app.vo.MultiselectOnDemandData;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

/**
 * Multi-select component data
 * @author Rustem Nizamiev
 * @since 14 Sep 2006
 */
class QMultiSelectModelImpl extends QFormElementModelImpl implements QMultiSelectModel {
    private String dialogCaption;

    public QMultiSelectModelImpl(MultiselectFieldMeta fieldMeta) {
        setMeta(fieldMeta);
        setCaption(fieldMeta.getCaption());
        this.dialogCaption = fieldMeta.getCaption();
        setData(new MultiselectFieldData());
    }

    public MultiselectFieldMeta getMeta() {
        if (null == getBaseMeta()) {
            setMeta(new MultiselectFieldMeta());
        }
        return (MultiselectFieldMeta) getBaseMeta();
    }

    public void setMeta(MultiselectFieldMeta meta) {
        setBaseMeta(meta);
    }

    public MultiselectFieldData getData() {
        if (null == getBaseData()) {
            setData(new MultiselectFieldData());
        }
        return ((MultiselectFieldData) getBaseData());
    }

    public void setData(MultiselectFieldData data) {
        MultiselectFieldMeta meta = getMeta();
        if (meta.isDynamic()) {
            // update meta
            meta.setAvailableChoises(data.getAvailableChoises());
            setMeta(meta);
        }
        setBaseData(data);
    }

    public String getDialogCaption() {
        return dialogCaption;
    }

    public void setDialogCaption(String dialogCaption) {
        this.dialogCaption = dialogCaption;
    }

    public void fireModelChanged() {
        fireModelDataChanged();
    }

    public boolean isValid() {
        return !(getMeta().isRequired() && getData().isEmpty());
    }

    public String getErrorTitle() {
        return DEFAULT_REQUIRED_FIELD_MESSAGE;
    }

    public int getDataType() {
        return THE_TYPE;
    }

    public void cloneDataFrom(QFormElementModel sameTypeControlModel) throws DataCloneException {
        if (THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel.getDataType());
        }
        QMultiSelectModel model = (QMultiSelectModel) sameTypeControlModel;
        setDialogCaption(model.getDialogCaption());
        setCaption(model.getMeta().getCaption());
        setMeta(model.getMeta());
        setData((MultiselectFieldData) model.getData().cloneData());
    }

    public boolean isLinkable() {
        return true;
    }

    public void setFieldOnDemandData(FieldOnDemandData onDemandData) {
        MultiselectOnDemandData demandData = (MultiselectOnDemandData) onDemandData;
        if(getMeta().isDynamic()) {
            // update meta
            getMeta().setAvailableChoises(demandData.getAvailableChoises());
            fireModelMetaChanged();
        }
        super.setFieldOnDemandData(onDemandData);
    }
}
