/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.textarea;

import com.queplix.core.client.controls.QFormElement;
import com.queplix.core.client.controls.QFormElementController;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementView;
import com.queplix.core.client.app.vo.TextareaFieldMeta;

public class QTextArea implements QFormElement {
    public static final int DEFAULT_WIDTH = 15;
    public static final int DEFAULT_HEIGHT = 4;
    public static final int DEFAULT_LAYOUT = QTextAreaLayout.HORIZONTAL;

    private QTextAreaModelImpl model;
    private QTextAreaViewImpl view;
    private QTextAreaControllerImpl controller;

    public QTextArea(TextareaFieldMeta textareaFieldMeta, int layout, int width, int height) {
        model = new QTextAreaModelImpl(textareaFieldMeta);
        view = new QTextAreaViewImpl(model, layout, width, height);
        controller = new QTextAreaControllerImpl(model, view);
    }

    public QTextArea(TextareaFieldMeta textareaFieldMeta, int layout) {
        this(textareaFieldMeta, layout, DEFAULT_WIDTH, DEFAULT_HEIGHT);
    }

    public QTextAreaController getController() {
        return controller;
    }

    public QTextAreaModel getModel() {
        return model;
    }

    public QTextAreaView getView() {
        return view;
    }

    public QFormElementModel getBaseModel() {
        return model;
    }

    public QFormElementView getBaseView() {
        return view;
    }

    public QFormElementController getBaseController() {
        return controller;
    }
}
