/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.controls.textbox;

import com.queplix.core.client.i18n.I18N;
import com.queplix.core.client.app.vo.TextBoxFieldMeta;
import com.queplix.core.client.app.vo.TextboxFieldData;
import com.queplix.core.client.controls.DataCloneException;
import com.queplix.core.client.controls.QFormElementModel;
import com.queplix.core.client.controls.QFormElementModelImpl;

class QTextBoxModelImpl extends QFormElementModelImpl implements QTextBoxModel {
    public QTextBoxModelImpl(TextBoxFieldMeta meta) {
        setMeta(meta);
        setData(new TextboxFieldData());
    }

    public TextBoxFieldMeta getMeta () {
        if (null == super.getBaseMeta()) {
            setMeta(new TextBoxFieldMeta());
        }
        return (TextBoxFieldMeta) super.getBaseMeta();
    }
    
    public void setMeta (TextBoxFieldMeta meta) {
        super.setBaseMeta(meta);
    }

    public TextboxFieldData getData () {
        if(null == super.getBaseData()) {
            setData(new TextboxFieldData());
        }
        return ((TextboxFieldData) super.getBaseData());
    }
        
    public void setData (TextboxFieldData data) {
        super.setBaseData(data);
    }

    public boolean isValid() {
        if(getMeta().isRequired() && getData().isEmpty()) {
            return false;
        } else if (!getData().isEmpty()){ 
            String str = getData().getText();
            String pattern = getMeta().getPattern();
            return pattern == null || str.matches(pattern);
        } else {
            return true;
        }
    }

    public String getErrorTitle() {
        String ret = "";
        if(getMeta().isRequired() && getData().isEmpty()) {
            ret = DEFAULT_REQUIRED_FIELD_MESSAGE;
        } else if (!getData().isEmpty()){
            String str = getData().getText();
            String pattern = getMeta().getPattern();
            if(pattern != null) {
                if (!str.matches(pattern)) {
                    ret = I18N.getMessages().invalidFieldFormat();
                }
            }
        }
        return ret;
    }

    public int getDataType() {
        return THE_TYPE;
    }
    
    public void cloneDataFrom(QFormElementModel sameTypeControlModel) throws DataCloneException {
        if(THE_TYPE != sameTypeControlModel.getDataType()) {
            throw new DataCloneException("Could not clone data for "
                    + THE_TYPE + ", from " + sameTypeControlModel.getDataType());
        }
        QTextBoxModel model = (QTextBoxModel) sameTypeControlModel;
        setData((TextboxFieldData) model.getData().cloneData());
        setMeta(model.getMeta());
    }

    public boolean isLinkable() {
        return true;
    }
}
