/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.email;

import com.queplix.core.client.i18n.I18N;

public final class EmailComposeHelper {

    // =============================================================== Constants

    public static final String FROM_MAP_FIELD = "from";
    public static final String TO_MAP_FIELD = "to";
    public static final String CC_MAP_FIELD = "cc";
    public static final String SUBJECT_MAP_FIELD = "subject";
    public static final String BODY_MAP_FIELD = "body";
    
    public static final String EXIT_CONFIRMATION_MSG = I18N.getMessages().emailExitConfirmation();
    public static final String DIALOG_CAPTION = I18N.getMessages().emailDialogCaption();
    public static final String EMAIL_SEND_FAILED = I18N.getMessages().emailSendFailed();

    public static final String ERR_MSG_EMPTY_FIELDS = I18N.getMessages().emailEmptyFields();
    public static final String ERR_MSG_NO_ACTIVE_RECORD = I18N.getMessages().emailActivateRecordFirst();
    public static final String ATTACHMENT_CAPTION = I18N.getMessages().emailAttachmentDialogCaption();
    
    // ================================================================= Methods    
}
