/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.mainframe;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.TabMeta;
import com.queplix.core.client.common.event.EventSource;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * Contains adhoc reports opearations
 *
 * @author Sergey Kozmin
 * @since 16.04.2007
 */
public interface AdhocOperations {
    /**
     * Set filters for forms.
     *
     * @param filters          collection of the
     *                         {@link com.queplix.core.client.app.vo.EntityData} objects
     * @param clearFormsBefore should forms be cleaned before data updated
     */
    public void setFormsFilters(Collection filters, boolean clearFormsBefore);

    /**
     * @return the base event source.
     */
    public EventSource getEventSource();

    /**
     * @return list of entity data filters. List<EntityData>
     */
    public List getAdhocFilters();

    /**
     * enables all forms for adhoc design
     */
    public void enableAdhocForAllForms();

    /**
     * Set element in(added to) adhoc report.
     *
     * @param elementId element id
     * @param index     form index where element resides
     */
    public void setAdhocElementIn(String elementId, FamgMeta.Index index);

    /**
     * Set element out of(not in) adhoc report.
     *
     * @param elementId element id
     * @param index     form index where element resides
     */
    public void setAdhocElementOut(String elementId, FamgMeta.Index index);

    /**
     * Set all elements in the given tab that contains in #inReportList to the
     * "in_report" state,
     * and all other in the given tab to "out_of_report" state.
     *
     * @param inReport Set<AdhocData>
     * @param index    tab index
     */
    public void setAdhocData(Set inReport, TabMeta.Index index);

    /**
     * This method disables all forms in tab with index = tabIndex for report
     * design than enables all joinable forms of form with index = formIndex
     * in tab with index = tabIndex in report design mode.
     *
     * @param formIndex initial adhoc form index
     * @param tabIndex  initialized tab index.
     */
    public void enableAdhocForJoinable(FamgMeta.Index formIndex,
                                       TabMeta.Index tabIndex);

    /**
     * This method disables all forms for report design, which not joined with
     * the given form and set "not_in_report" state other froms.
     *
     * @param formIndex enables all joinable to this index forms.
     */
    public void enableAdhocForJoinable(FamgMeta.Index formIndex);

    /**
     * @return does any not saved data exist in application.
     */
    public boolean isInEditMode();
}
